#ifndef FUNCTION_LOGGER_H
#define FUNCTION_LOGGER_H

class CDebugLogger;

enum ParamTypes
{
  ParamType_bool,
  ParamType_UInt8,
  ParamType_UInt16,
  ParamType_UInt32,
  ParamType_AgtSizeT,
  ParamType_AgtValueT,
  ParamType_AgtPortHandleT,
  ParamType_EPCIEHostControllerVersion,
  ParamType_EPCIEDecProp,
  ParamType_EPCIECompQueue,
  ParamType_EPCIEDec,
  ParamType_EPCIESiStatus,
  ParamType_EPCIESi,
  ParamType_EPCIEHwChannelFunction,
  ParamType_EPCIEVCResourceId,
  ParamType_EPCIEVCResourceProp,
  ParamType_EPCIEVCResourceStatusProp,
  ParamType_EPCIEProtRule,
  ParamType_EPCIEProtRuleVC,
  ParamType_EPCIEProtRuleFunction,
  ParamType_EPCIEBlock,
  ParamType_EPCIEReqBeh,
  ParamType_EPCIECompBeh,
  ParamType_EPCIEDllPhy,
  ParamType_EPCIEExerciser,
  ParamType_EPCIEBlockGen,
  ParamType_EPCIEReqBehGen,
  ParamType_EPCIECompBehGen,
  ParamType_EPCIEVC,
  ParamType_EPCIEConfigSpace,
  ParamType_EPCIELinkStateDirect,
  ParamType_EPCIERxError,
  ParamType_EPCIERxErrorStatus,
  ParamType_EPCIEExerciserStatus,
  ParamType_EPCIEPattern,
  ParamType_EPCIEPerformanceCounterStatus,
  ParamType_EPCIEPerformanceCounterVCStatus,
  ParamType_EPCIEPerformanceCounterFunctionStatus,
  ParamType_EPCIETriggerOut,
  ParamType_EPCIEDllpStatus,
  ParamType_EPCIEDllp,
  ParamType_EPCIEDllpControl,
  ParamType_EPCIEScratchPadRegister,
  ParamType_EPCIEExerciserPhyStatus,
  ParamType_EPCIEExerciserHwChannelStatus
};

#define stringify( name ) # name

class CFunctionLogger
{
private:
  CDebugLogger* m_pDebugLogger;
  char m_strFunctionName[200];

public:
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p );
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p, bool bDoNotLogFnName_p );
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
    ParamTypes paramType1_p, int nValue1_p);
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
    ParamTypes paramType1_p, int nValue1_p,
    ParamTypes paramType2_p, int nValue2_p );
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
    ParamTypes paramType1_p, int nValue1_p,
    ParamTypes paramType2_p, int nValue2_p,
    ParamTypes paramType3_p, int nValue3_p );
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
    ParamTypes paramType1_p, int nValue1_p,
    ParamTypes paramType2_p, int nValue2_p,
    ParamTypes paramType3_p, int nValue3_p,
    ParamTypes paramType4_p, int nValue4_p );
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
    ParamTypes paramType1_p, int nValue1_p,
    ParamTypes paramType2_p, int nValue2_p,
    ParamTypes paramType3_p, int nValue3_p,
    ParamTypes paramType4_p, int nValue4_p,
    ParamTypes paramType5_p, int nValue5_p );
  CFunctionLogger( CDebugLogger* pDebugLogger_p, char* strFunctionName_p,
    ParamTypes paramType1_p, int nValue1_p,
    ParamTypes paramType2_p, int nValue2_p,
    ParamTypes paramType3_p, int nValue3_p,
    ParamTypes paramType4_p, int nValue4_p,
    ParamTypes paramType5_p, int nValue5_p,
    ParamTypes paramType6_p, int nValue6_p );

  virtual ~CFunctionLogger();

  void WriteDecUInt( unsigned int uVal_p );
  void WriteHexUInt( unsigned int uVal_p );

  void Write( const char* strMessage_p );
  void WriteLine( const char* strMessage_p );
  void WriteLineBreak();

private:
  void IncrementIndent();
  void DecrementIndent();

  void PrintParam( ParamTypes paramType, int nValue_p );
};

#endif